<?php //b120997f9a9b4b8947df0197dbb7f0c1
/** @noinspection all */

namespace App {

    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Notifications\DatabaseNotificationCollection;
    use Illuminate\Support\Carbon;
    use Laravel\Sanctum\PersonalAccessToken;
    use LaravelIdea\Helper\App\_IH_AdminRole_C;
    use LaravelIdea\Helper\App\_IH_AdminRole_QB;
    use LaravelIdea\Helper\App\_IH_Admin_C;
    use LaravelIdea\Helper\App\_IH_Admin_QB;
    use LaravelIdea\Helper\App\_IH_BlogCategory_C;
    use LaravelIdea\Helper\App\_IH_BlogCategory_QB;
    use LaravelIdea\Helper\App\_IH_Blog_C;
    use LaravelIdea\Helper\App\_IH_Blog_QB;
    use LaravelIdea\Helper\App\_IH_CauseCategory_C;
    use LaravelIdea\Helper\App\_IH_CauseCategory_QB;
    use LaravelIdea\Helper\App\_IH_CauseLogs_C;
    use LaravelIdea\Helper\App\_IH_CauseLogs_QB;
    use LaravelIdea\Helper\App\_IH_CauseUpdate_C;
    use LaravelIdea\Helper\App\_IH_CauseUpdate_QB;
    use LaravelIdea\Helper\App\_IH_Cause_C;
    use LaravelIdea\Helper\App\_IH_Cause_QB;
    use LaravelIdea\Helper\App\_IH_ClientArea_C;
    use LaravelIdea\Helper\App\_IH_ClientArea_QB;
    use LaravelIdea\Helper\App\_IH_Comment_C;
    use LaravelIdea\Helper\App\_IH_Comment_QB;
    use LaravelIdea\Helper\App\_IH_ContactInfoItem_C;
    use LaravelIdea\Helper\App\_IH_ContactInfoItem_QB;
    use LaravelIdea\Helper\App\_IH_Counterup_C;
    use LaravelIdea\Helper\App\_IH_Counterup_QB;
    use LaravelIdea\Helper\App\_IH_Country_C;
    use LaravelIdea\Helper\App\_IH_Country_QB;
    use LaravelIdea\Helper\App\_IH_DonationWithdraw_C;
    use LaravelIdea\Helper\App\_IH_DonationWithdraw_QB;
    use LaravelIdea\Helper\App\_IH_EventAttendance_C;
    use LaravelIdea\Helper\App\_IH_EventAttendance_QB;
    use LaravelIdea\Helper\App\_IH_EventPaymentLogs_C;
    use LaravelIdea\Helper\App\_IH_EventPaymentLogs_QB;
    use LaravelIdea\Helper\App\_IH_EventsCategory_C;
    use LaravelIdea\Helper\App\_IH_EventsCategory_QB;
    use LaravelIdea\Helper\App\_IH_Events_C;
    use LaravelIdea\Helper\App\_IH_Events_QB;
    use LaravelIdea\Helper\App\_IH_Faq_C;
    use LaravelIdea\Helper\App\_IH_Faq_QB;
    use LaravelIdea\Helper\App\_IH_Feedback_C;
    use LaravelIdea\Helper\App\_IH_Feedback_QB;
    use LaravelIdea\Helper\App\_IH_FlagReport_C;
    use LaravelIdea\Helper\App\_IH_FlagReport_QB;
    use LaravelIdea\Helper\App\_IH_Gift_C;
    use LaravelIdea\Helper\App\_IH_Gift_QB;
    use LaravelIdea\Helper\App\_IH_HeaderSlider_C;
    use LaravelIdea\Helper\App\_IH_HeaderSlider_QB;
    use LaravelIdea\Helper\App\_IH_ImageGalleryCategory_C;
    use LaravelIdea\Helper\App\_IH_ImageGalleryCategory_QB;
    use LaravelIdea\Helper\App\_IH_ImageGallery_C;
    use LaravelIdea\Helper\App\_IH_ImageGallery_QB;
    use LaravelIdea\Helper\App\_IH_JobApplicant_C;
    use LaravelIdea\Helper\App\_IH_JobApplicant_QB;
    use LaravelIdea\Helper\App\_IH_JobsCategory_C;
    use LaravelIdea\Helper\App\_IH_JobsCategory_QB;
    use LaravelIdea\Helper\App\_IH_Jobs_C;
    use LaravelIdea\Helper\App\_IH_Jobs_QB;
    use LaravelIdea\Helper\App\_IH_KeyFeatures_C;
    use LaravelIdea\Helper\App\_IH_KeyFeatures_QB;
    use LaravelIdea\Helper\App\_IH_Language_C;
    use LaravelIdea\Helper\App\_IH_Language_QB;
    use LaravelIdea\Helper\App\_IH_MediaUpload_C;
    use LaravelIdea\Helper\App\_IH_MediaUpload_QB;
    use LaravelIdea\Helper\App\_IH_MedicalDocument_C;
    use LaravelIdea\Helper\App\_IH_MedicalDocument_QB;
    use LaravelIdea\Helper\App\_IH_Menu_C;
    use LaravelIdea\Helper\App\_IH_Menu_QB;
    use LaravelIdea\Helper\App\_IH_MobileSlider_C;
    use LaravelIdea\Helper\App\_IH_MobileSlider_QB;
    use LaravelIdea\Helper\App\_IH_Newsletter_C;
    use LaravelIdea\Helper\App\_IH_Newsletter_QB;
    use LaravelIdea\Helper\App\_IH_Notification_C;
    use LaravelIdea\Helper\App\_IH_Notification_QB;
    use LaravelIdea\Helper\App\_IH_Page_C;
    use LaravelIdea\Helper\App\_IH_Page_QB;
    use LaravelIdea\Helper\App\_IH_Recuring_C;
    use LaravelIdea\Helper\App\_IH_Recuring_QB;
    use LaravelIdea\Helper\App\_IH_RewardRedeem_C;
    use LaravelIdea\Helper\App\_IH_RewardRedeem_QB;
    use LaravelIdea\Helper\App\_IH_Reward_C;
    use LaravelIdea\Helper\App\_IH_Reward_QB;
    use LaravelIdea\Helper\App\_IH_SocialIcons_C;
    use LaravelIdea\Helper\App\_IH_SocialIcons_QB;
    use LaravelIdea\Helper\App\_IH_StaticOption_C;
    use LaravelIdea\Helper\App\_IH_StaticOption_QB;
    use LaravelIdea\Helper\App\_IH_SuccessStoryCategory_C;
    use LaravelIdea\Helper\App\_IH_SuccessStoryCategory_QB;
    use LaravelIdea\Helper\App\_IH_SuccessStory_C;
    use LaravelIdea\Helper\App\_IH_SuccessStory_QB;
    use LaravelIdea\Helper\App\_IH_SupportTicketDepartment_C;
    use LaravelIdea\Helper\App\_IH_SupportTicketDepartment_QB;
    use LaravelIdea\Helper\App\_IH_SupportTicketMessage_C;
    use LaravelIdea\Helper\App\_IH_SupportTicketMessage_QB;
    use LaravelIdea\Helper\App\_IH_SupportTicket_C;
    use LaravelIdea\Helper\App\_IH_SupportTicket_QB;
    use LaravelIdea\Helper\App\_IH_TaxLog_C;
    use LaravelIdea\Helper\App\_IH_TaxLog_QB;
    use LaravelIdea\Helper\App\_IH_TeamMember_C;
    use LaravelIdea\Helper\App\_IH_TeamMember_QB;
    use LaravelIdea\Helper\App\_IH_Testimonial_C;
    use LaravelIdea\Helper\App\_IH_Testimonial_QB;
    use LaravelIdea\Helper\App\_IH_TopbarInfo_C;
    use LaravelIdea\Helper\App\_IH_TopbarInfo_QB;
    use LaravelIdea\Helper\App\_IH_UserFollow_C;
    use LaravelIdea\Helper\App\_IH_UserFollow_QB;
    use LaravelIdea\Helper\App\_IH_User_C;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\App\_IH_Widgets_C;
    use LaravelIdea\Helper\App\_IH_Widgets_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_C;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_QB;
    use Spatie\Permission\Models\Permission;
    use Spatie\Permission\Models\Role;
    
    /**
     * @property int $id
     * @property string $name
     * @property string $username
     * @property string $email
     * @property int $email_verified
     * @property string $role
     * @property string|null $image
     * @property string $password
     * @property string $status
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property _IH_Permission_C|Permission[] $permissions
     * @property-read int $permissions_count
     * @method MorphToMany|_IH_Permission_QB permissions()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property _IH_Role_C|Role[] $roles
     * @property-read int $roles_count
     * @method MorphToMany|_IH_Role_QB roles()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @method static _IH_Admin_QB onWriteConnection()
     * @method _IH_Admin_QB newQuery()
     * @method static _IH_Admin_QB on(null|string $connection = null)
     * @method static _IH_Admin_QB query()
     * @method static _IH_Admin_QB with(array|string $relations)
     * @method _IH_Admin_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Admin_C|Admin[] all()
     * @foreignLinks id,\App\Cause,admin_id|id,\App\SupportTicket,admin_id
     * @mixin _IH_Admin_QB
     */
    class Admin extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $permission
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_AdminRole_QB onWriteConnection()
     * @method _IH_AdminRole_QB newQuery()
     * @method static _IH_AdminRole_QB on(null|string $connection = null)
     * @method static _IH_AdminRole_QB query()
     * @method static _IH_AdminRole_QB with(array|string $relations)
     * @method _IH_AdminRole_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AdminRole_C|AdminRole[] all()
     * @mixin _IH_AdminRole_QB
     */
    class AdminRole extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string $blog_content
     * @property int $blog_categories_id
     * @property string $tags
     * @property string|null $image
     * @property string|null $author
     * @property string|null $status
     * @property string|null $excerpt
     * @property string|null $meta_title
     * @property string|null $meta_tags
     * @property string|null $meta_description
     * @property string|null $og_meta_title
     * @property string|null $og_meta_description
     * @property string|null $og_meta_image
     * @property string|null $user_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property BlogCategory $category
     * @method BelongsTo|_IH_BlogCategory_QB category()
     * @property Admin|null $user
     * @method BelongsTo|_IH_Admin_QB user()
     * @method static _IH_Blog_QB onWriteConnection()
     * @method _IH_Blog_QB newQuery()
     * @method static _IH_Blog_QB on(null|string $connection = null)
     * @method static _IH_Blog_QB query()
     * @method static _IH_Blog_QB with(array|string $relations)
     * @method _IH_Blog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Blog_C|Blog[] all()
     * @ownLinks blog_categories_id,\App\BlogCategory,id|user_id,\App\User,id
     * @mixin _IH_Blog_QB
     */
    class Blog extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_BlogCategory_QB onWriteConnection()
     * @method _IH_BlogCategory_QB newQuery()
     * @method static _IH_BlogCategory_QB on(null|string $connection = null)
     * @method static _IH_BlogCategory_QB query()
     * @method static _IH_BlogCategory_QB with(array|string $relations)
     * @method _IH_BlogCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_BlogCategory_C|BlogCategory[] all()
     * @foreignLinks id,\App\Blog,blog_categories_id
     * @mixin _IH_BlogCategory_QB
     */
    class BlogCategory extends Model {}
    
    /**
     * @property int $id
     * @property int $cause_update_id
     * @property string $title
     * @property string|null $cause_content
     * @property string $amount
     * @property string|null $raised
     * @property string|null $status
     * @property string|null $image
     * @property string|null $image_gallery
     * @property string|null $slug
     * @property string|null $excerpt
     * @property string|null $meta_title
     * @property string|null $meta_tags
     * @property string|null $meta_description
     * @property int|null $user_id
     * @property int|null $admin_id
     * @property int|null $categories_id
     * @property string|null $created_by
     * @property string|null $faq
     * @property string|null $deadline
     * @property string|null $featured
     * @property string|null $og_meta_title
     * @property string|null $og_meta_description
     * @property string|null $og_meta_image
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $medical_document
     * @property string|null $emmergency
     * @property string|null $reward
     * @property string|null $gift_status
     * @property string|null $monthly_donation_status
     * @property Admin|null $admin
     * @method BelongsTo|_IH_Admin_QB admin()
     * @property CauseCategory|null $category
     * @method BelongsTo|_IH_CauseCategory_QB category()
     * @property CauseLogs $cause_logs
     * @method BelongsTo|_IH_CauseLogs_QB cause_logs()
     * @property CauseUpdate $cause_update
     * @method BelongsTo|_IH_CauseUpdate_QB cause_update()
     * @property _IH_CauseUpdate_C|CauseUpdate[] $cause_updates_data
     * @property-read int $cause_updates_data_count
     * @method HasMany|_IH_CauseUpdate_QB cause_updates_data()
     * @property _IH_Comment_C|Comment[] $comments
     * @property-read int $comments_count
     * @method HasMany|_IH_Comment_QB comments()
     * @property _IH_Cause_C|Cause[] $donors
     * @property-read int $donors_count
     * @method HasMany|_IH_Cause_QB donors()
     * @property _IH_Gift_C|Gift[] $gift
     * @property-read int $gift_count
     * @method BelongsToMany|_IH_Gift_QB gift()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @property _IH_DonationWithdraw_C|DonationWithdraw[] $withdraws
     * @property-read int $withdraws_count
     * @method HasMany|_IH_DonationWithdraw_QB withdraws()
     * @method static _IH_Cause_QB onWriteConnection()
     * @method _IH_Cause_QB newQuery()
     * @method static _IH_Cause_QB on(null|string $connection = null)
     * @method static _IH_Cause_QB query()
     * @method static _IH_Cause_QB with(array|string $relations)
     * @method _IH_Cause_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Cause_C|Cause[] all()
     * @ownLinks cause_update_id,\App\CauseUpdate,id|user_id,\App\User,id|admin_id,\App\Admin,id
     * @foreignLinks id,\App\CauseLogs,cause_id|id,\App\Comment,cause_id|id,\App\FlagReport,cause_id
     * @mixin _IH_Cause_QB
     */
    class Cause extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property string|null $description
     * @property string|null $image
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Cause_C|Cause[] $donation
     * @property-read int $donation_count
     * @method HasMany|_IH_Cause_QB donation()
     * @method static _IH_CauseCategory_QB onWriteConnection()
     * @method _IH_CauseCategory_QB newQuery()
     * @method static _IH_CauseCategory_QB on(null|string $connection = null)
     * @method static _IH_CauseCategory_QB query()
     * @method static _IH_CauseCategory_QB with(array|string $relations)
     * @method _IH_CauseCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CauseCategory_C|CauseCategory[] all()
     * @mixin _IH_CauseCategory_QB
     */
    class CauseCategory extends Model {}
    
    /**
     * @property int $id
     * @property string $cause_id
     * @property string|null $email
     * @property string|null $name
     * @property string|null $status
     * @property string|null $amount
     * @property string|null $transaction_id
     * @property string|null $payment_gateway
     * @property string|null $track
     * @property string|null $user_id
     * @property int|null $anonymous
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $manual_payment_attachment
     * @property int|null $reward_point
     * @property int|null $reward_amount
     * @property string|null $recuring_token
     * @property bool $recuring_token_verify
     * @property int|null $gift_id
     * @property string|null $address
     * @property string|null $phone
     * @property string|null $custom_fields
     * @property string|null $attachments
     * @property int $added_in_raised_amount
     * @property Cause $cause
     * @method BelongsTo|_IH_Cause_QB cause()
     * @property Gift|null $gift
     * @method BelongsTo|_IH_Gift_QB gift()
     * @property _IH_Recuring_C|Recuring[] $recurings
     * @property-read int $recurings_count
     * @method HasMany|_IH_Recuring_QB recurings()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @property DonationWithdraw $withdraw
     * @method BelongsTo|_IH_DonationWithdraw_QB withdraw()
     * @method static _IH_CauseLogs_QB onWriteConnection()
     * @method _IH_CauseLogs_QB newQuery()
     * @method static _IH_CauseLogs_QB on(null|string $connection = null)
     * @method static _IH_CauseLogs_QB query()
     * @method static _IH_CauseLogs_QB with(array|string $relations)
     * @method _IH_CauseLogs_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CauseLogs_C|CauseLogs[] all()
     * @ownLinks cause_id,\App\Cause,id|user_id,\App\User,id|gift_id,\App\Gift,id
     * @foreignLinks id,\App\Recuring,cause_log_id|id,\Illuminate\Notifications\DatabaseNotification,cause_log_id
     * @mixin _IH_CauseLogs_QB
     */
    class CauseLogs extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property string|null $description
     * @property string|null $image
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Cause $cause
     * @method BelongsTo|_IH_Cause_QB cause()
     * @method static _IH_CauseUpdate_QB onWriteConnection()
     * @method _IH_CauseUpdate_QB newQuery()
     * @method static _IH_CauseUpdate_QB on(null|string $connection = null)
     * @method static _IH_CauseUpdate_QB query()
     * @method static _IH_CauseUpdate_QB with(array|string $relations)
     * @method _IH_CauseUpdate_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CauseUpdate_C|CauseUpdate[] all()
     * @foreignLinks id,\App\Cause,cause_update_id
     * @mixin _IH_CauseUpdate_QB
     */
    class CauseUpdate extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property string|null $url
     * @property string|null $image
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_ClientArea_QB onWriteConnection()
     * @method _IH_ClientArea_QB newQuery()
     * @method static _IH_ClientArea_QB on(null|string $connection = null)
     * @method static _IH_ClientArea_QB query()
     * @method static _IH_ClientArea_QB with(array|string $relations)
     * @method _IH_ClientArea_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ClientArea_C|ClientArea[] all()
     * @mixin _IH_ClientArea_QB
     */
    class ClientArea extends Model {}
    
    /**
     * @property int $id
     * @property int $cause_id
     * @property int $user_id
     * @property string $commented_by
     * @property string $comment_content
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Cause $cause
     * @method BelongsTo|_IH_Cause_QB cause()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Comment_QB onWriteConnection()
     * @method _IH_Comment_QB newQuery()
     * @method static _IH_Comment_QB on(null|string $connection = null)
     * @method static _IH_Comment_QB query()
     * @method static _IH_Comment_QB with(array|string $relations)
     * @method _IH_Comment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Comment_C|Comment[] all()
     * @ownLinks cause_id,\App\Cause,id|user_id,\App\User,id
     * @mixin _IH_Comment_QB
     */
    class Comment extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string $icon
     * @property string $description
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_ContactInfoItem_QB onWriteConnection()
     * @method _IH_ContactInfoItem_QB newQuery()
     * @method static _IH_ContactInfoItem_QB on(null|string $connection = null)
     * @method static _IH_ContactInfoItem_QB query()
     * @method static _IH_ContactInfoItem_QB with(array|string $relations)
     * @method _IH_ContactInfoItem_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ContactInfoItem_C|ContactInfoItem[] all()
     * @mixin _IH_ContactInfoItem_QB
     */
    class ContactInfoItem extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string $number
     * @property string|null $extra_text
     * @property string|null $icon
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Counterup_QB onWriteConnection()
     * @method _IH_Counterup_QB newQuery()
     * @method static _IH_Counterup_QB on(null|string $connection = null)
     * @method static _IH_Counterup_QB query()
     * @method static _IH_Counterup_QB with(array|string $relations)
     * @method _IH_Counterup_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Counterup_C|Counterup[] all()
     * @mixin _IH_Counterup_QB
     */
    class Counterup extends Model {}
    
    /**
     * @property int $id
     * @property string|null $name
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Country_QB onWriteConnection()
     * @method _IH_Country_QB newQuery()
     * @method static _IH_Country_QB on(null|string $connection = null)
     * @method static _IH_Country_QB query()
     * @method static _IH_Country_QB with(array|string $relations)
     * @method _IH_Country_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Country_C|Country[] all()
     * @foreignLinks id,\App\User,country_id
     * @mixin _IH_Country_QB
     */
    class Country extends Model {}
    
    /**
     * @property int $id
     * @property int $donation_id
     * @property int $user_id
     * @property string $payment_gateway
     * @property string $withdraw_amount
     * @property string $payment_account_details
     * @property string|null $additional_comment_by_user
     * @property string|null $transaction_id
     * @property string|null $additional_comment_by_admin
     * @property string|null $payment_receipt
     * @property string $payment_status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Cause $cause
     * @method BelongsTo|_IH_Cause_QB cause()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_DonationWithdraw_QB onWriteConnection()
     * @method _IH_DonationWithdraw_QB newQuery()
     * @method static _IH_DonationWithdraw_QB on(null|string $connection = null)
     * @method static _IH_DonationWithdraw_QB query()
     * @method static _IH_DonationWithdraw_QB with(array|string $relations)
     * @method _IH_DonationWithdraw_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DonationWithdraw_C|DonationWithdraw[] all()
     * @ownLinks user_id,\App\User,id
     * @mixin _IH_DonationWithdraw_QB
     */
    class DonationWithdraw extends Model {}
    
    /**
     * @property int $id
     * @property string $status
     * @property string $payment_status
     * @property string|null $event_name
     * @property string|null $checkout_type
     * @property int|null $user_id
     * @property string|null $event_cost
     * @property string|null $event_id
     * @property string|null $quantity
     * @property string|null $custom_fields
     * @property string|null $attachment
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Events|null $event
     * @method BelongsTo|_IH_Events_QB event()
     * @property EventPaymentLogs $log
     * @method HasOne|_IH_EventPaymentLogs_QB log()
     * @method static _IH_EventAttendance_QB onWriteConnection()
     * @method _IH_EventAttendance_QB newQuery()
     * @method static _IH_EventAttendance_QB on(null|string $connection = null)
     * @method static _IH_EventAttendance_QB query()
     * @method static _IH_EventAttendance_QB with(array|string $relations)
     * @method _IH_EventAttendance_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_EventAttendance_C|EventAttendance[] all()
     * @ownLinks user_id,\App\User,id|event_id,\App\Events,id
     * @mixin _IH_EventAttendance_QB
     */
    class EventAttendance extends Model {}
    
    /**
     * @property int $id
     * @property string|null $email
     * @property string|null $name
     * @property string|null $event_name
     * @property string|null $event_cost
     * @property string|null $event_gateway
     * @property string|null $package_gateway
     * @property int|null $attendance_id
     * @property string|null $status
     * @property string|null $transaction_id
     * @property string|null $track
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $manual_payment_attachment
     * @property EventAttendance|null $attendance
     * @method BelongsTo|_IH_EventAttendance_QB attendance()
     * @method static _IH_EventPaymentLogs_QB onWriteConnection()
     * @method _IH_EventPaymentLogs_QB newQuery()
     * @method static _IH_EventPaymentLogs_QB on(null|string $connection = null)
     * @method static _IH_EventPaymentLogs_QB query()
     * @method static _IH_EventPaymentLogs_QB with(array|string $relations)
     * @method _IH_EventPaymentLogs_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_EventPaymentLogs_C|EventPaymentLogs[] all()
     * @mixin _IH_EventPaymentLogs_QB
     */
    class EventPaymentLogs extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string|null $content
     * @property string|null $category_id
     * @property string|null $status
     * @property string $date
     * @property string $time
     * @property string $cost
     * @property string $available_tickets
     * @property string|null $image
     * @property string|null $organizer
     * @property string|null $organizer_email
     * @property string|null $organizer_website
     * @property string|null $organizer_phone
     * @property string|null $venue
     * @property string|null $slug
     * @property string|null $venue_location
     * @property string|null $venue_phone
     * @property string|null $meta_title
     * @property string|null $meta_tags
     * @property string|null $meta_description
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property EventsCategory|null $category
     * @method HasOne|_IH_EventsCategory_QB category()
     * @method static _IH_Events_QB onWriteConnection()
     * @method _IH_Events_QB newQuery()
     * @method static _IH_Events_QB on(null|string $connection = null)
     * @method static _IH_Events_QB query()
     * @method static _IH_Events_QB with(array|string $relations)
     * @method _IH_Events_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Events_C|Events[] all()
     * @foreignLinks id,\App\EventAttendance,event_id
     * @mixin _IH_Events_QB
     */
    class Events extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_EventsCategory_QB onWriteConnection()
     * @method _IH_EventsCategory_QB newQuery()
     * @method static _IH_EventsCategory_QB on(null|string $connection = null)
     * @method static _IH_EventsCategory_QB query()
     * @method static _IH_EventsCategory_QB with(array|string $relations)
     * @method _IH_EventsCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_EventsCategory_C|EventsCategory[] all()
     * @mixin _IH_EventsCategory_QB
     */
    class EventsCategory extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string|null $status
     * @property string|null $is_open
     * @property string|null $description
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Faq_QB onWriteConnection()
     * @method _IH_Faq_QB newQuery()
     * @method static _IH_Faq_QB on(null|string $connection = null)
     * @method static _IH_Faq_QB query()
     * @method static _IH_Faq_QB with(array|string $relations)
     * @method _IH_Faq_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Faq_C|Faq[] all()
     * @mixin _IH_Faq_QB
     */
    class Faq extends Model {}
    
    /**
     * @method static _IH_Feedback_QB onWriteConnection()
     * @method _IH_Feedback_QB newQuery()
     * @method static _IH_Feedback_QB on(null|string $connection = null)
     * @method static _IH_Feedback_QB query()
     * @method static _IH_Feedback_QB with(array|string $relations)
     * @method _IH_Feedback_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Feedback_C|Feedback[] all()
     * @mixin _IH_Feedback_QB
     */
    class Feedback extends Model {}
    
    /**
     * @property int $id
     * @property int $cause_id
     * @property string $name
     * @property string $email
     * @property string $subject
     * @property string $description
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Cause $cause
     * @method BelongsTo|_IH_Cause_QB cause()
     * @method static _IH_FlagReport_QB onWriteConnection()
     * @method _IH_FlagReport_QB newQuery()
     * @method static _IH_FlagReport_QB on(null|string $connection = null)
     * @method static _IH_FlagReport_QB query()
     * @method static _IH_FlagReport_QB with(array|string $relations)
     * @method _IH_FlagReport_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_FlagReport_C|FlagReport[] all()
     * @ownLinks cause_id,\App\Cause,id
     * @mixin _IH_FlagReport_QB
     */
    class FlagReport extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property int $amount
     * @property string $gifts
     * @property string|null $description
     * @property string|null $delivery_date
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $image
     * @property int $creator_id
     * @property string $creator_type
     * @property _IH_Cause_C|Cause[] $cause
     * @property-read int $cause_count
     * @method BelongsToMany|_IH_Cause_QB cause()
     * @method static _IH_Gift_QB onWriteConnection()
     * @method _IH_Gift_QB newQuery()
     * @method static _IH_Gift_QB on(null|string $connection = null)
     * @method static _IH_Gift_QB query()
     * @method static _IH_Gift_QB with(array|string $relations)
     * @method _IH_Gift_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Gift_C|Gift[] all()
     * @foreignLinks id,\App\CauseLogs,gift_id
     * @mixin _IH_Gift_QB
     */
    class Gift extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property string|null $subtitle
     * @property string|null $title_ext
     * @property string|null $subtitle_ext
     * @property string|null $details
     * @property string|null $btn_text
     * @property string|null $btn_url
     * @property string|null $btn_status
     * @property string|null $support_title
     * @property string|null $support_details
     * @property string|null $image
     * @property string|null $icon
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_HeaderSlider_QB onWriteConnection()
     * @method _IH_HeaderSlider_QB newQuery()
     * @method static _IH_HeaderSlider_QB on(null|string $connection = null)
     * @method static _IH_HeaderSlider_QB query()
     * @method static _IH_HeaderSlider_QB with(array|string $relations)
     * @method _IH_HeaderSlider_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_HeaderSlider_C|HeaderSlider[] all()
     * @mixin _IH_HeaderSlider_QB
     */
    class HeaderSlider extends Model {}
    
    /**
     * @property int $id
     * @property string $image
     * @property string|null $title
     * @property int|null $cat_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_ImageGallery_QB onWriteConnection()
     * @method _IH_ImageGallery_QB newQuery()
     * @method static _IH_ImageGallery_QB on(null|string $connection = null)
     * @method static _IH_ImageGallery_QB query()
     * @method static _IH_ImageGallery_QB with(array|string $relations)
     * @method _IH_ImageGallery_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ImageGallery_C|ImageGallery[] all()
     * @mixin _IH_ImageGallery_QB
     */
    class ImageGallery extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_ImageGalleryCategory_QB onWriteConnection()
     * @method _IH_ImageGalleryCategory_QB newQuery()
     * @method static _IH_ImageGalleryCategory_QB on(null|string $connection = null)
     * @method static _IH_ImageGalleryCategory_QB query()
     * @method static _IH_ImageGalleryCategory_QB with(array|string $relations)
     * @method _IH_ImageGalleryCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ImageGalleryCategory_C|ImageGalleryCategory[] all()
     * @mixin _IH_ImageGalleryCategory_QB
     */
    class ImageGalleryCategory extends Model {}
    
    /**
     * @property int $id
     * @property int $jobs_id
     * @property string|null $track
     * @property string|null $transaction_id
     * @property string|null $name
     * @property string|null $email
     * @property string|null $application_fee
     * @property string|null $payment_gateway
     * @property string|null $payment_status
     * @property string|null $form_content
     * @property string|null $attachment
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Jobs $job
     * @method BelongsTo|_IH_Jobs_QB job()
     * @method static _IH_JobApplicant_QB onWriteConnection()
     * @method _IH_JobApplicant_QB newQuery()
     * @method static _IH_JobApplicant_QB on(null|string $connection = null)
     * @method static _IH_JobApplicant_QB query()
     * @method static _IH_JobApplicant_QB with(array|string $relations)
     * @method _IH_JobApplicant_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_JobApplicant_C|JobApplicant[] all()
     * @ownLinks jobs_id,\App\Jobs,id
     * @mixin _IH_JobApplicant_QB
     */
    class JobApplicant extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string $position
     * @property string $company_name
     * @property string|null $category_id
     * @property string|null $vacancy
     * @property string|null $job_responsibility
     * @property string|null $employment_status
     * @property string|null $education_requirement
     * @property string|null $job_context
     * @property string|null $experience_requirement
     * @property string|null $additional_requirement
     * @property string|null $job_location
     * @property string|null $salary
     * @property string|null $other_benefits
     * @property string|null $email
     * @property string|null $status
     * @property string|null $deadline
     * @property string|null $application_fee_status
     * @property float|null $application_fee
     * @property string|null $meta_tags
     * @property string|null $slug
     * @property string|null $meta_description
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property JobsCategory|null $category
     * @method HasOne|_IH_JobsCategory_QB category()
     * @method static _IH_Jobs_QB onWriteConnection()
     * @method _IH_Jobs_QB newQuery()
     * @method static _IH_Jobs_QB on(null|string $connection = null)
     * @method static _IH_Jobs_QB query()
     * @method static _IH_Jobs_QB with(array|string $relations)
     * @method _IH_Jobs_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Jobs_C|Jobs[] all()
     * @foreignLinks id,\App\JobApplicant,jobs_id
     * @mixin _IH_Jobs_QB
     */
    class Jobs extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_JobsCategory_QB onWriteConnection()
     * @method _IH_JobsCategory_QB newQuery()
     * @method static _IH_JobsCategory_QB on(null|string $connection = null)
     * @method static _IH_JobsCategory_QB query()
     * @method static _IH_JobsCategory_QB with(array|string $relations)
     * @method _IH_JobsCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_JobsCategory_C|JobsCategory[] all()
     * @mixin _IH_JobsCategory_QB
     */
    class JobsCategory extends Model {}
    
    /**
     * @method static _IH_KeyFeatures_QB onWriteConnection()
     * @method _IH_KeyFeatures_QB newQuery()
     * @method static _IH_KeyFeatures_QB on(null|string $connection = null)
     * @method static _IH_KeyFeatures_QB query()
     * @method static _IH_KeyFeatures_QB with(array|string $relations)
     * @method _IH_KeyFeatures_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_KeyFeatures_C|KeyFeatures[] all()
     * @mixin _IH_KeyFeatures_QB
     */
    class KeyFeatures extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $slug
     * @property string|null $direction
     * @property string|null $status
     * @property int|null $default
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Language_QB onWriteConnection()
     * @method _IH_Language_QB newQuery()
     * @method static _IH_Language_QB on(null|string $connection = null)
     * @method static _IH_Language_QB query()
     * @method static _IH_Language_QB with(array|string $relations)
     * @method _IH_Language_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Language_C|Language[] all()
     * @mixin _IH_Language_QB
     */
    class Language extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string $path
     * @property string|null $alt
     * @property string|null $size
     * @property string|null $dimensions
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_MediaUpload_QB onWriteConnection()
     * @method _IH_MediaUpload_QB newQuery()
     * @method static _IH_MediaUpload_QB on(null|string $connection = null)
     * @method static _IH_MediaUpload_QB query()
     * @method static _IH_MediaUpload_QB with(array|string $relations)
     * @method _IH_MediaUpload_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MediaUpload_C|MediaUpload[] all()
     * @mixin _IH_MediaUpload_QB
     */
    class MediaUpload extends Model {}
    
    /**
     * @property Cause $cause
     * @method BelongsTo|_IH_Cause_QB cause()
     * @method static _IH_MedicalDocument_QB onWriteConnection()
     * @method _IH_MedicalDocument_QB newQuery()
     * @method static _IH_MedicalDocument_QB on(null|string $connection = null)
     * @method static _IH_MedicalDocument_QB query()
     * @method static _IH_MedicalDocument_QB with(array|string $relations)
     * @method _IH_MedicalDocument_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MedicalDocument_C|MedicalDocument[] all()
     * @mixin _IH_MedicalDocument_QB
     */
    class MedicalDocument extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string|null $content
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Menu_QB onWriteConnection()
     * @method _IH_Menu_QB newQuery()
     * @method static _IH_Menu_QB on(null|string $connection = null)
     * @method static _IH_Menu_QB query()
     * @method static _IH_Menu_QB with(array|string $relations)
     * @method _IH_Menu_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Menu_C|Menu[] all()
     * @mixin _IH_Menu_QB
     */
    class Menu extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property string|null $image
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $donation_id
     * @property string|null $subtitle
     * @method static _IH_MobileSlider_QB onWriteConnection()
     * @method _IH_MobileSlider_QB newQuery()
     * @method static _IH_MobileSlider_QB on(null|string $connection = null)
     * @method static _IH_MobileSlider_QB query()
     * @method static _IH_MobileSlider_QB with(array|string $relations)
     * @method _IH_MobileSlider_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MobileSlider_C|MobileSlider[] all()
     * @mixin _IH_MobileSlider_QB
     */
    class MobileSlider extends Model {}
    
    /**
     * @property int $id
     * @property int|null $user_id
     * @property string $email
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $token
     * @property string|null $verified
     * @property int $subscribe_status
     * @method static _IH_Newsletter_QB onWriteConnection()
     * @method _IH_Newsletter_QB newQuery()
     * @method static _IH_Newsletter_QB on(null|string $connection = null)
     * @method static _IH_Newsletter_QB query()
     * @method static _IH_Newsletter_QB with(array|string $relations)
     * @method _IH_Newsletter_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Newsletter_C|Newsletter[] all()
     * @ownLinks user_id,\App\User,id
     * @mixin _IH_Newsletter_QB
     */
    class Newsletter extends Model {}
    
    /**
     * @property int $id
     * @property string|null $type
     * @property string|null $title
     * @property int|null $cause_log_id
     * @property int|null $user_campaign_id
     * @property int|null $withdraw_id
     * @property string $seen
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property CauseLogs|null $cause_log
     * @method BelongsTo|_IH_CauseLogs_QB cause_log()
     * @property DonationWithdraw|null $cause_withdraw
     * @method BelongsTo|_IH_DonationWithdraw_QB cause_withdraw()
     * @property Cause|null $user_campaign
     * @method BelongsTo|_IH_Cause_QB user_campaign()
     * @method static _IH_Notification_QB onWriteConnection()
     * @method _IH_Notification_QB newQuery()
     * @method static _IH_Notification_QB on(null|string $connection = null)
     * @method static _IH_Notification_QB query()
     * @method static _IH_Notification_QB with(array|string $relations)
     * @method _IH_Notification_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Notification_C|Notification[] all()
     * @ownLinks cause_log_id,\App\CauseLogs,id
     * @mixin _IH_Notification_QB
     */
    class Notification extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property string|null $page_content
     * @property string|null $slug
     * @property string|null $meta_description
     * @property string|null $meta_title
     * @property string|null $meta_tags
     * @property string|null $og_meta_description
     * @property string|null $og_meta_title
     * @property string|null $og_meta_image
     * @property string|null $status
     * @property string|null $visibility
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Page_QB onWriteConnection()
     * @method _IH_Page_QB newQuery()
     * @method static _IH_Page_QB on(null|string $connection = null)
     * @method static _IH_Page_QB query()
     * @method static _IH_Page_QB with(array|string $relations)
     * @method _IH_Page_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Page_C|Page[] all()
     * @mixin _IH_Page_QB
     */
    class Page extends Model {}
    
    /**
     * @property int $id
     * @property int $cause_log_id
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $expire_date
     * @property CauseLogs $donation_log
     * @method BelongsTo|_IH_CauseLogs_QB donation_log()
     * @method static _IH_Recuring_QB onWriteConnection()
     * @method _IH_Recuring_QB newQuery()
     * @method static _IH_Recuring_QB on(null|string $connection = null)
     * @method static _IH_Recuring_QB query()
     * @method static _IH_Recuring_QB with(array|string $relations)
     * @method _IH_Recuring_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Recuring_C|Recuring[] all()
     * @ownLinks cause_log_id,\App\CauseLogs,id
     * @mixin _IH_Recuring_QB
     */
    class Recuring extends Model {}
    
    /**
     * @property int $id
     * @property string|null $reward_title
     * @property int $reward_goal_from
     * @property int $reward_goal_to
     * @property string $reward_point
     * @property int|null $reward_amount
     * @property string|null $reward_expire_date
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Reward_QB onWriteConnection()
     * @method _IH_Reward_QB newQuery()
     * @method static _IH_Reward_QB on(null|string $connection = null)
     * @method static _IH_Reward_QB query()
     * @method static _IH_Reward_QB with(array|string $relations)
     * @method _IH_Reward_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Reward_C|Reward[] all()
     * @mixin _IH_Reward_QB
     */
    class Reward extends Model {}
    
    /**
     * @property int $id
     * @property int $donation_id
     * @property int $user_id
     * @property int $donation_log_id
     * @property string $payment_gateway
     * @property string $withdraw_request_amount
     * @property string $payment_account_details
     * @property string|null $payment_information
     * @property string|null $additional_comment_by_user
     * @property string|null $transaction_id
     * @property string|null $additional_comment_by_admin
     * @property string|null $payment_receipt
     * @property string $payment_status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Cause $cause
     * @method BelongsTo|_IH_Cause_QB cause()
     * @property CauseLogs $log
     * @method BelongsTo|_IH_CauseLogs_QB log()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_RewardRedeem_QB onWriteConnection()
     * @method _IH_RewardRedeem_QB newQuery()
     * @method static _IH_RewardRedeem_QB on(null|string $connection = null)
     * @method static _IH_RewardRedeem_QB query()
     * @method static _IH_RewardRedeem_QB with(array|string $relations)
     * @method _IH_RewardRedeem_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RewardRedeem_C|RewardRedeem[] all()
     * @ownLinks user_id,\App\User,id
     * @mixin _IH_RewardRedeem_QB
     */
    class RewardRedeem extends Model {}
    
    /**
     * @property int $id
     * @property string $icon
     * @property string $url
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_SocialIcons_QB onWriteConnection()
     * @method _IH_SocialIcons_QB newQuery()
     * @method static _IH_SocialIcons_QB on(null|string $connection = null)
     * @method static _IH_SocialIcons_QB query()
     * @method static _IH_SocialIcons_QB with(array|string $relations)
     * @method _IH_SocialIcons_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SocialIcons_C|SocialIcons[] all()
     * @mixin _IH_SocialIcons_QB
     */
    class SocialIcons extends Model {}
    
    /**
     * @property int $id
     * @property string $option_name
     * @property string|null $option_value
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_StaticOption_QB onWriteConnection()
     * @method _IH_StaticOption_QB newQuery()
     * @method static _IH_StaticOption_QB on(null|string $connection = null)
     * @method static _IH_StaticOption_QB query()
     * @method static _IH_StaticOption_QB with(array|string $relations)
     * @method _IH_StaticOption_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_StaticOption_C|StaticOption[] all()
     * @mixin _IH_StaticOption_QB
     */
    class StaticOption extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string $content
     * @property int $success_story_category_id
     * @property string|null $image
     * @property string|null $status
     * @property string|null $excerpt
     * @property string|null $meta_title
     * @property string|null $meta_tags
     * @property string|null $meta_description
     * @property string|null $og_meta_title
     * @property string|null $og_meta_description
     * @property string|null $og_meta_image
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property SuccessStoryCategory $category
     * @method BelongsTo|_IH_SuccessStoryCategory_QB category()
     * @method static _IH_SuccessStory_QB onWriteConnection()
     * @method _IH_SuccessStory_QB newQuery()
     * @method static _IH_SuccessStory_QB on(null|string $connection = null)
     * @method static _IH_SuccessStory_QB query()
     * @method static _IH_SuccessStory_QB with(array|string $relations)
     * @method _IH_SuccessStory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SuccessStory_C|SuccessStory[] all()
     * @ownLinks success_story_category_id,\App\SuccessStoryCategory,id
     * @mixin _IH_SuccessStory_QB
     */
    class SuccessStory extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_SuccessStoryCategory_QB onWriteConnection()
     * @method _IH_SuccessStoryCategory_QB newQuery()
     * @method static _IH_SuccessStoryCategory_QB on(null|string $connection = null)
     * @method static _IH_SuccessStoryCategory_QB query()
     * @method static _IH_SuccessStoryCategory_QB with(array|string $relations)
     * @method _IH_SuccessStoryCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SuccessStoryCategory_C|SuccessStoryCategory[] all()
     * @foreignLinks id,\App\SuccessStory,success_story_category_id
     * @mixin _IH_SuccessStoryCategory_QB
     */
    class SuccessStoryCategory extends Model {}
    
    /**
     * @property int $id
     * @property int|null $user_id
     * @property int|null $admin_id
     * @property int|null $department_id
     * @property string|null $title
     * @property string|null $via
     * @property string|null $operating_system
     * @property string|null $user_agent
     * @property string|null $description
     * @property string|null $subject
     * @property string|null $status
     * @property string|null $priority
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Admin|null $admin
     * @method BelongsTo|_IH_Admin_QB admin()
     * @property SupportTicketDepartment|null $department
     * @method BelongsTo|_IH_SupportTicketDepartment_QB department()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_SupportTicket_QB onWriteConnection()
     * @method _IH_SupportTicket_QB newQuery()
     * @method static _IH_SupportTicket_QB on(null|string $connection = null)
     * @method static _IH_SupportTicket_QB query()
     * @method static _IH_SupportTicket_QB with(array|string $relations)
     * @method _IH_SupportTicket_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SupportTicket_C|SupportTicket[] all()
     * @ownLinks user_id,\App\User,id|admin_id,\App\Admin,id
     * @foreignLinks id,\App\SupportTicketMessage,support_ticket_id
     * @mixin _IH_SupportTicket_QB
     */
    class SupportTicket extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_SupportTicketDepartment_QB onWriteConnection()
     * @method _IH_SupportTicketDepartment_QB newQuery()
     * @method static _IH_SupportTicketDepartment_QB on(null|string $connection = null)
     * @method static _IH_SupportTicketDepartment_QB query()
     * @method static _IH_SupportTicketDepartment_QB with(array|string $relations)
     * @method _IH_SupportTicketDepartment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SupportTicketDepartment_C|SupportTicketDepartment[] all()
     * @mixin _IH_SupportTicketDepartment_QB
     */
    class SupportTicketDepartment extends Model {}
    
    /**
     * @property int $id
     * @property int|null $support_ticket_id
     * @property string|null $message
     * @property string|null $notify
     * @property string|null $attachment
     * @property string|null $type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_SupportTicketMessage_QB onWriteConnection()
     * @method _IH_SupportTicketMessage_QB newQuery()
     * @method static _IH_SupportTicketMessage_QB on(null|string $connection = null)
     * @method static _IH_SupportTicketMessage_QB query()
     * @method static _IH_SupportTicketMessage_QB with(array|string $relations)
     * @method _IH_SupportTicketMessage_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SupportTicketMessage_C|SupportTicketMessage[] all()
     * @ownLinks support_ticket_id,\App\SupportTicket,id
     * @mixin _IH_SupportTicketMessage_QB
     */
    class SupportTicketMessage extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string|null $title
     * @property string|null $start_date
     * @property string|null $end_date
     * @property string|null $attachment
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_TaxLog_QB onWriteConnection()
     * @method _IH_TaxLog_QB newQuery()
     * @method static _IH_TaxLog_QB on(null|string $connection = null)
     * @method static _IH_TaxLog_QB query()
     * @method static _IH_TaxLog_QB with(array|string $relations)
     * @method _IH_TaxLog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TaxLog_C|TaxLog[] all()
     * @ownLinks user_id,\App\User,id
     * @mixin _IH_TaxLog_QB
     */
    class TaxLog extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $designation
     * @property string|null $description
     * @property string|null $image
     * @property string|null $icon_one
     * @property string|null $icon_two
     * @property string|null $icon_three
     * @property string|null $icon_one_url
     * @property string|null $icon_two_url
     * @property string|null $icon_three_url
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_TeamMember_QB onWriteConnection()
     * @method _IH_TeamMember_QB newQuery()
     * @method static _IH_TeamMember_QB on(null|string $connection = null)
     * @method static _IH_TeamMember_QB query()
     * @method static _IH_TeamMember_QB with(array|string $relations)
     * @method _IH_TeamMember_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TeamMember_C|TeamMember[] all()
     * @mixin _IH_TeamMember_QB
     */
    class TeamMember extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $image
     * @property string $description
     * @property int|null $rating_star
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Testimonial_QB onWriteConnection()
     * @method _IH_Testimonial_QB newQuery()
     * @method static _IH_Testimonial_QB on(null|string $connection = null)
     * @method static _IH_Testimonial_QB query()
     * @method static _IH_Testimonial_QB with(array|string $relations)
     * @method _IH_Testimonial_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Testimonial_C|Testimonial[] all()
     * @mixin _IH_Testimonial_QB
     */
    class Testimonial extends Model {}
    
    /**
     * @property int $id
     * @property string $icon
     * @property string $details
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_TopbarInfo_QB onWriteConnection()
     * @method _IH_TopbarInfo_QB newQuery()
     * @method static _IH_TopbarInfo_QB on(null|string $connection = null)
     * @method static _IH_TopbarInfo_QB query()
     * @method static _IH_TopbarInfo_QB with(array|string $relations)
     * @method _IH_TopbarInfo_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TopbarInfo_C|TopbarInfo[] all()
     * @mixin _IH_TopbarInfo_QB
     */
    class TopbarInfo extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $email
     * @property string $username
     * @property string|null $email_verified
     * @property string|null $phone
     * @property string|null $email_verify_token
     * @property string|null $address
     * @property string|null $state
     * @property string|null $city
     * @property string|null $zipcode
     * @property int|null $country_id
     * @property string $password
     * @property string $status
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $facebook_id
     * @property string|null $google_id
     * @property string|null $image
     * @property int|null $monthly_income
     * @property int|null $annual_income
     * @property string|null $income_source
     * @property string|null $nid_image
     * @property string|null $driving_license_image
     * @property string|null $passport_image
     * @property string|null $tax_verify_status
     * @property string $campaign_permission
     * @property string|null $user_verify_nid
     * @property string|null $user_verify_address
     * @property int $user_verify_status
     * @property Country|null $country
     * @method BelongsTo|_IH_Country_QB country()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property _IH_PersonalAccessToken_C|PersonalAccessToken[] $tokens
     * @property-read int $tokens_count
     * @method MorphToMany|_IH_PersonalAccessToken_QB tokens()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all()
     * @ownLinks country_id,\App\Country,id
     * @foreignLinks id,\App\Blog,user_id|id,\App\Newsletter,user_id|id,\App\EventAttendance,user_id|id,\App\Cause,user_id|id,\App\CauseLogs,user_id|id,\App\Comment,user_id|id,\App\DonationWithdraw,user_id|id,\App\SupportTicket,user_id|id,\App\TaxLog,user_id|id,\App\UserFollow,user_id|id,\App\RewardRedeem,user_id
     * @mixin _IH_User_QB
     */
    class User extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $campaign_owner_id
     * @property string $follow_status
     * @property string|null $user_type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_UserFollow_QB onWriteConnection()
     * @method _IH_UserFollow_QB newQuery()
     * @method static _IH_UserFollow_QB on(null|string $connection = null)
     * @method static _IH_UserFollow_QB query()
     * @method static _IH_UserFollow_QB with(array|string $relations)
     * @method _IH_UserFollow_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserFollow_C|UserFollow[] all()
     * @ownLinks user_id,\App\User,id
     * @mixin _IH_UserFollow_QB
     */
    class UserFollow extends Model {}
    
    /**
     * @property int $id
     * @property string|null $widget_area
     * @property int|null $widget_order
     * @property string|null $widget_location
     * @property string $widget_name
     * @property string $widget_content
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Widgets_QB onWriteConnection()
     * @method _IH_Widgets_QB newQuery()
     * @method static _IH_Widgets_QB on(null|string $connection = null)
     * @method static _IH_Widgets_QB query()
     * @method static _IH_Widgets_QB with(array|string $relations)
     * @method _IH_Widgets_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Widgets_C|Widgets[] all()
     * @mixin _IH_Widgets_QB
     */
    class Widgets extends Model {}
}